<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('releases', 'lyrics_duration')) {
            Schema::table('releases', function (Blueprint $table) {
                $table->dropColumn('lyrics_duration');
            });
        }

        Schema::table('releases', function (Blueprint $table) {
            $table->string('lyrics_duration')->nullable()->after('p_line_year');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('releases', function (Blueprint $table) {
            $table->dropColumn('lyrics_duration');
        });
    }
};
